{{ *****************************************************
   *  Example2.1  : For "ET-BASE PX32 V1.0             *
   *                                                   *
   *  File Name   : Ex2.1_VGA_TextRom.spin              *
   *  Compiler    : Propeller V1.06                    *
   *  Create By   : Sittiphol Yooyod (www.ett.co.th)   *
   *  Last Update : 28/January/2007                    *
   *  Function    : Display Text in ROM to VGA          *                  
   *                                                   *
   ***************************************************** }}

  
CON

    _clkmode        = xtal1 + pll16x   ''Set PLL = x16
    _xinfreq        = 5_000_000        ''Crystal 5.0 Mhz ;System Clock =16x5=80Mhz


  ''---- Initial VGA -----
      
    cols = 32     ''Screen :15 row x 32 Colum
    rows = 15

    screensize = cols * rows
    lastrow = screensize - cols

    vga_count = 21


VAR

  long  col, row, color, flag
  
  word  screen[screensize]
  long  colors[8 * 2]

  long  vga_status    '0/1/2 = off/visible/invisible      read-only   (21 longs)
  long  vga_enable    '0/non-0 = off/on                   write-only
  long  vga_pins      '%pppttt = pins                     write-only
  long  vga_mode      '%tihv = tile,interlace,hpol,vpol   write-only
  long  vga_screen    'pointer to screen (words)          write-only
  long  vga_colors    'pointer to colors (longs)          write-only            
  long  vga_ht        'horizontal tiles                   write-only
  long  vga_vt        'vertical tiles                     write-only
  long  vga_hx        'horizontal tile expansion          write-only
  long  vga_vx        'vertical tile expansion            write-only
  long  vga_ho        'horizontal offset                  write-only
  long  vga_vo        'vertical offset                    write-only
  long  vga_hd        'horizontal display ticks           write-only
  long  vga_hf        'horizontal front porch ticks       write-only
  long  vga_hs        'horizontal sync ticks              write-only
  long  vga_hb        'horizontal back porch ticks        write-only
  long  vga_vd        'vertical display lines             write-only
  long  vga_vf        'vertical front porch lines         write-only
  long  vga_vs        'vertical sync lines                write-only
  long  vga_vb        'vertical back porch lines          write-only
  long  vga_rate      'tick rate (Hz)                     write-only


OBJ

  vga : "vga"


PUB main | count0,count1   

   start(16)                            ''Start VGA PIN 16..23


  str(string(13,"  *ETT DEMO TEXT ON VGA(16x32)*",13))        '' Sent Megsage ON VGA
  
  out($0C)                                                    '' Set Color 
  out($02)                                                    '' Text:Violet,Back Ground Text:Black 
  str(string(13,"      Example Text In ROM       "))          '' Sent Data Text ON VGA

  out($0C)                                                    '' Set Color 
  out($01)                                                    '' Text:Yellow,Back Ground Text:Blue 
  str(string(" A B C D E F G H I J K L M N O P Q R S T U V W X Y Z ")) '' Sent Megsage ON VGA
  repeat 11
    out(" ")  ''Space
  
  out($0C)                                                    '' Set Color 
  out($05)                                                    '' Text:Green,Back Ground Text:bule 
  str(string(" a b c d e f g h i j k l m n o p q r s t u v w x y z ")) '' Sent Megsage ON VGA   
  repeat 11
   out(" ")  ''Space


  out($0C)                                                    '' Set Color 
  out($06)                                                    '' Text:Pink,Back Ground Text:Blue 
  str(string(" 0 1 2 3 4 5 6 7 8 9 ! @ # $ % & * ( = - + [ { < ? /  ")) '' Sent Megsage ON VGA   
  repeat 11
   out(" ")  ''Space


  out($0C)                                                    '' Set Color 
  out($07)                                                    '' Text:RED,Back Ground Text:Blue 
  str(string(13,"         WWW.ETT.CO.TH          "))           '' Sent Data Text ON VGA

 
  out($0C)                                                    '' Set Color 
  out($03)                                                    '' Text:White,Back Ground Text:Blue  
  repeat
    out($0A)           '' Set Position Text Axle-X
    out(4)             '' X-Position = Coloum 4 
    out($0B)           '' Set Position Text Axle-Y
    out(13)            '' Y-Position = Line 13
    hex(count0++,4)    '' Convert Hex 4 digit
     
    out($0A)           '' Set Position Text Axle-X
    out(24)            '' X-Position = Coloum 24 
    out($0B)           '' Set Position Text Axle-Y
    out(13)            '' Y-Position = Line 13
    hex(count1--,4)
      



    
PUB start(basepin) : okay

'' Start terminal - starts a cog
'' returns false if no cog available
''
'' requires at least 80MHz system clock

  setcolors(@palette)
  out(0)
  
  longmove(@vga_status, @vga_params, vga_count)
  vga_pins := basepin | %000_111
  vga_screen := @screen
  vga_colors := @colors
  vga_rate := clkfreq >> 2
  
  okay := vga.start(@vga_status)


PUB stop

'' Stop terminal - frees a cog

  vga.stop


PUB str(stringptr)

'' Print a zero-terminated string

  repeat strsize(stringptr)
    out(byte[stringptr++])


PUB dec(value) | i

'' Print a decimal number

  if value < 0
    -value
    out("-")

  i := 1_000_000_000

  repeat 10
    if value => i
      out(value / i + "0")
      value //= i
      result~~
    elseif result or i == 1
      out("0")
    i /= 10


PUB hex(value, digits)

'' Print a hexadecimal number

  value <<= (8 - digits) << 2
  repeat digits
    out(lookupz((value <-= 4) & $F : "0".."9", "A".."F"))


PUB bin(value, digits)

'' Print a binary number

  value <<= 32 - digits
  repeat digits
    out((value <-= 1) & 1 + "0")


PUB out(c) | i, k

'' Output a character
''
''     $00 = clear screen
''     $01 = home
''     $08 = backspace
''     $09 = tab (8 spaces per)
''     $0A = set X position (X follows)
''     $0B = set Y position (Y follows)
''     $0C = set color (color follows)
''     $0D = return
''  others = printable characters

  case flag
    $00: case c
           $00: wordfill(@screen, $220, screensize)
                col := row := 0
           $01: col := row := 0
           $08: if col
                  col--
           $09: repeat
                  print(" ")
                while col & 7
           $0A..$0C: flag := c
                     return
           $0D: newline
           other: print(c)
    $0A: col := c // cols
    $0B: row := c // rows
    $0C: color := c & 7
  flag := 0


PUB setcolors(colorptr) | i, fore, back

'' Override default color palette
'' colorptr must point to a list of up to 8 colors
'' arranged as follows (where r, g, b are 0..3):
''
''               fore   back
''               ------------
'' palette  byte %%rgb, %%rgb     'color 0
''          byte %%rgb, %%rgb     'color 1
''          byte %%rgb, %%rgb     'color 2
''          ...

  repeat i from 0 to 7
    fore := byte[colorptr][i << 1] << 2
    back := byte[colorptr][i << 1 + 1] << 2
    colors[i << 1]     := fore << 24 + back << 16 + fore << 8 + back
    colors[i << 1 + 1] := fore << 24 + fore << 16 + back << 8 + back


PRI print(c)

  screen[row * cols + col] := (color << 1 + c & 1) << 10 + $200 + c & $FE
  if ++col == cols
    newline


PRI newline | i

  col := 0
  if ++row == rows
    row--
    wordmove(@screen, @screen[cols], lastrow)   'scroll lines
    wordfill(@screen[lastrow], $220, cols)      'clear new line


DAT

vga_params              long    0               'status
                        long    1               'enable
                        long    0               'pins
                        long    %1000           'mode
                        long    0               'videobase
                        long    0               'colorbase
                        long    cols            'hc
                        long    rows            'vc
                        long    1               'hx
                        long    1               'vx
                        long    0               'ho
                        long    0               'vo
                        long    512             'hd 
                        long    10              'hf
                        long    75              'hs
                        long    43              'hb
                        long    480             'vd
                        long    11              'vf
                        long    2               'vs
                        long    31              'vb
                        long    0               'rate

                        '        fore   back
                        '         RGB    RGB
palette                 byte    %%300, %%003    '0      Red / blue
                        byte    %%330, %%003    '1   yellow / blue
                        byte    %%202, %%000    '2  magenta / black
                        byte    %%333, %%003    '3     white/ blue
                        byte    %%033, %%011    '4     cyan / dark cyan
                        byte    %%030, %%003    '5    green / blue
                        byte    %%311, %%003    '6     pink / blue
                        byte    %%300, %%000    '7     RED  / black
                        